<?php
use yii\helpers\Html;
use common\widgets\Alert;
use kartik\widgets\ActiveForm;
use backend\models\Post;
use backend\models\Tag;
use backend\models\Blog;

$fullurlexp = $_SERVER['REQUEST_SCHEME'] . '://' . $_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];

$this->title = "Explore Incredible India – Culture and Travel | Explore Our India";
\Yii::$app->view->registerMetaTag([
    'name' => 'description',
    'content' => "Explore the beauty of Incredible India with Explore Our India—your travel companion for top destinations, rich culture, festivals, and expert tips..",
]);
\Yii::$app->view->registerMetaTag([
    'name' => 'keywords',
    'content' => "India travel guide, best places to visit in India, Indian festivals, Indian culture, tourism in India, Indian heritage, famous Indian destinations, spiritual tourism, adventure travel India, travel blog India, historical places in India, Explore Our India, Heritage, Religious, Adventure, Wildlife, Ecotourism, Beach, WaterFalls, Mountains, Blog, Temple, Mandir, Paragliding,	Wildlife Safari, Rafting, Scuba Diving, Zip-Lining, Top tourist Places in India, Tourist Places in India, Heritage Place, Religious Place, Adventure Place, Andhra Pradesh Tourism,  Arunachal Pradesh Tourism,  Assam Tourism, Bihar Tourism,  Chhattisgarh Tourism,  Goa Tourism, Gujarat Tourism,  Haryana Tourism, Himachal Pradesh Tourism, Himachal Tourism,  Jharkhand Tourism, Karnataka Tourism, Kerala Tourism, Madhya Pradesh Tourism,  Maharashtra Tourism,  Manipur Tourism,  Meghalaya Tourism,  Mizoram Tourism,  Nagaland Tourism,  Odisha Tourism,  Punjab Tourism,  Rajasthan Tourism, Sikkim Tourism,  Tamil Nadu Tourism,  Telangana Tourism,  Tripura Tourism,  Uttar Pradesh Tourism,  Uttarakhand Tourism,  West Bengal Tourism,  Chandigarh Tourism,  Dadra & Nagar Haveli and Daman & Diu Tourism,  Delhi Tourism,  Jammu and Kashmir Tourism,  Lakshadweep Tourism,  Puducherry Tourism,  Ladakh Tourism, tourist places in delhi,  tourist places around delhi ncr, tourist places around 500 kms,  tourist places at nainital,  tourist places Allahabad,  tourist places around delhi,  tourist places agra,  tourist places in himachal Pradesh, tourist places in Jaipur,  tourist places in india, tourist places in uttarakhand, tourist places in lucknow, tourist places Noida, tourist places near me ",
]);

$this->registerMetaTag(['property' => 'og:site_name', 'content' => 'Explore Our India'], 'og:site_name');
$this->registerMetaTag(['property' => 'og:title', 'content' => $this->title], 'og:title');
$this->registerMetaTag(['property' => 'og:description', 'content' => 'Explore the beauty of Incredible India with Explore Our India—your travel companion for top destinations, rich culture, festivals, and expert tips..'], 'og:description');
$this->registerMetaTag(['property' => 'og:url', 'content' => $fullurlexp], 'og:url');
$this->registerMetaTag(['property' => 'og:image', 'content' => 'https://www.exploreourindia.com/backend/web/images/post/big/8337_kashi vishwanath temple varanasi.webp'], 'og:image');
$this->registerMetaTag(['property' => 'og:type', 'content' => 'Website'], 'og:type');
$this->registerMetaTag(['property' => 'og:locale', 'content' => 'en'], 'og:locale');
$this->registerMetaTag(['property' => 'twitter:title', 'content' => $this->title], 'twitter:title');
$this->registerMetaTag(['property' => 'twitter:description', 'content' => 'Explore the beauty of Incredible India with Explore Our India—your travel companion for top destinations, rich culture, festivals, and expert tips..'], 'twitter:description');
$this->registerMetaTag(['property' => 'twitter:image', 'content' => 'https://www.exploreourindia.com/backend/web/images/post/big/8337_kashi vishwanath temple varanasi.webp'], 'twitter:image');

?>
 <style>
 .bdrhvr img:hover{
				border:5px solid #FC0}
				.bdrhvr img{
				border:5px solid #CCC}
				
				
				
				.hover {
  --c: #ff4400; /* the color */
  --s: .35em;
  
  line-height:1.1em;
  padding-bottom: calc(2.1*var(--s));
  background: 
    conic-gradient(from 135deg at top,var(--c) 90deg,#0000 0) 
      left 0 bottom var(--s)/calc(2*var(--s)) var(--s) repeat-x,
    conic-gradient(from -45deg at bottom,var(--c) 90deg,#0000 0) 
      left var(--s) bottom 0/calc(2*var(--s)) var(--s) repeat-x;
  -webkit-mask:
    linear-gradient(#000 0 0) content-box,
    linear-gradient(#000 0 0) 0/var(--_p,0%) padding-box no-repeat;
  transition: .5s;
  
}
.hover:hover {
  --_p: 100%;
  color: var(--c);
}


h3 {
  font-family: system-ui, sans-serif;
  font-size: 4rem;
  margin:0;
  cursor: pointer;
  padding: 0 .1em;
}


.hover14 figure {
	position: relative;
}
.hover14 figure::before {
	position: absolute;
	top: 0;
	left: -75%;
	z-index: 2;
	display: block;
	content: '';
	width: 50%;
	height: 100%;
	background: -webkit-linear-gradient(left, rgba(255,255,255,0) 0%, rgba(255,255,255,.3) 100%);
	background: linear-gradient(to right, rgba(255,255,255,0) 0%, rgba(255,255,255,.3) 100%);
	-webkit-transform: skewX(-25deg);
	transform: skewX(-25deg);
}
.hover14 figure:hover::before {
	-webkit-animation: shine .75s;
	animation: shine .75s;
}
@-webkit-keyframes shine {
	100% {
		left: 125%;
	}
}
@keyframes shine {
	100% {
		left: 125%;
	}
}
.box11 {
    --border-size: 6px;
    --border-angle: 0turn;
	border-radius:10px;
    width: 100%;
    height: auto;
    background-image: conic-gradient(from var(--border-angle), #fff, #fff 50%, #fff), conic-gradient(from var(--border-angle), transparent 20%, #08f, #f03);
    background-size: calc(100% - (var(--border-size) * 2)) calc(100% - (var(--border-size) * 2)), cover;
    background-position: center center;
    background-repeat: no-repeat;
    -webkit-animation: bg-spin 3s linear infinite;
    animation: bg-spin 5s linear infinite;
	padding-top:50px;
}

@-webkit-keyframes bg-spin {
    to {
        --border-angle: 1turn;
    }
}

@keyframes bg-spin {
    to {
        --border-angle: 1turn;
    }
}
.box11:hover {
    -webkit-animation-play-state: play;
    animation-play-state: play;
}
@property --border-angle {
    syntax: "<angle>";
    inherits: true;
    initial-value: 0turn;
} 
.google-auto-placed {
 display:none;
} 
</style>

<div role="main" class="main pt-3 mt-3">
    <div class="container">
     <div class="row pb-1" style="margin-top:5px;">    
        <div class="col-lg-7 mb-4 pb-2">
             <?=Html::a('<article class="thumb-info thumb-info-no-borders thumb-info-bottom-info thumb-info-bottom-info-dark thumb-info-bottom-info-show-more thumb-info-no-zoom border-radius-0"><div class="thumb-info-wrapper thumb-info-wrapper-opacity-6"> <img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$blogQuery->image.'" class="img-fluid" alt="'.$blogQuery->heading.'"><div class="thumb-info-title bg-transparent p-4"><div class="thumb-info-inner mt-1"><h2 class="font-weight-bold text-color-light line-height-2 text-5 mb-0">'.$blogQuery->heading.'</h2></div><div class="thumb-info-show-more-content"><p class="mb-0 text-1 line-height-9 mb-1 mt-2 text-light opacity-5">'.$blogQuery->limitTextWords(strip_tags($blogQuery->content), 20, true, true).'</p></div></div></div></article>', ['/blog/view', 'slug' => $blogQuery->slug])?>            
		</div>
        <div class="col-lg-5">
		<?php $postqQuery = Blog::find()->where(['status' => 1])->andwhere(['!=', 'id', $blogQuery->id])->orderBy(['id' => SORT_DESC])->limit(3)->all();
		      foreach($postqQuery as $ppostqQuery) {?>
          <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-2 mb-2">
            <div class="row align-items-center pb-1">
              <div class="col-sm-5"> 
                <?php if($ppostqQuery->image != '') {?>
                  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$ppostqQuery->image.'" alt="'.$ppostqQuery->heading.'" class="lazyload img-fluid border-radius-0" > ', ['/blog/view', 'slug' => $ppostqQuery->slug])?>
			    <?php } else { ?>
				  <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/photo-not-availabe.jpg" class="img-fluid border-radius-0">
				<?php } ?>
			  </div>
              <div class="col-sm-7 pl-sm-1">
                <div class="thumb-info-caption-text">
                  <h2 class="d-block line-height-2 text-4 text-dark font-weight-bold mt-2 mb-0"><?=Html::a($ppostqQuery->heading, ['/blog/view', 'slug' => $ppostqQuery->slug], ['class' => 'text-decoration-none text-color-dark'])?> </h2>
                   <p style="margin:0;"><?=$ppostqQuery->limitTextWords(strip_tags($ppostqQuery->content), 8, true, true)?></p>
                </div>
              </div>
            </div>
          </article>
			<?php } ?>
        </div>
      </div>      
    <div class="row pb-1 pt-0">
	  <div class="col-md-12">     
       <h1 class="font-weight-bold">Discover the Heart of Incredible India – Culture, Heritage, Travel & Adventure Awaits </h1>
           <p>“Atithi Devo Bhava” – In India, we treat guests as gods. At Explore Our India, we carry forward this timeless tradition by offering you immersive, authentic, and unforgettable journeys across the vast and vibrant land of Incredible India. From the majestic Himalayas in the north to the serene beaches of the south, India is a land of vibrant contrasts and unforgettable experiences. Whether you're a history lover, a nature enthusiast, or a spiritual seeker, there's something for everyone to explore in India.</p>
           <p>Some of the most visited places in India include the iconic Taj Mahal in Agra, the palaces of Rajasthan, the spiritual ghats of Varanasi, and the lush backwaters of Kerala. Each region offers a unique story, with diverse cuisines, languages, and traditions. Wondering about the best time to visit India? While the country is beautiful year-round, the cooler months from October to March are ideal for travel, especially if you're exploring the north. For a coastal escape, winter and early summer offer the perfect tropical weather. No matter how you choose to travel, one thing is certain: to explore India is to discover a world within a country—rich, diverse, and endlessly fascinating.</p>
          <div class="heading heading-border heading-middle-border">
            <h3 class="text-4"><strong class="font-weight-bold text-2 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Discover India’s Divine Spirit: Religious Tourism in India</strong></h3>
          </div>       
          <div class="row pb-1">
		    <div class="col-lg-3 hover mb-3"> 
			   <a href="https://www.exploreourindia.com/tag/temple"> <span class="bdrhvr hover14">
			  <figure> <img class="img-fluid rounded-circle mb-4 " src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/temple.webp" alt="Temple"> </figure>
				 <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Temple</span></h4>
				</span></a>
				</div>
				<div class="col-lg-3 hover mb-3"> 
			   <a href="https://www.exploreourindia.com/tag/gurudwara"> <span class="bdrhvr hover14">
			  <figure>  <img class="img-fluid rounded-circle mb-4" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/gurudwara.webp" alt="Gurudwara"> </figure>
				 <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Gurudwara</span></h4>
				</span></a>
				</div>
				<div class="col-lg-3 hover mb-3"> 
			   <a href="https://www.exploreourindia.com/tag/church"> <span class="bdrhvr hover14">
			 <figure>   <img class="img-fluid rounded-circle mb-4" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/church.webp" alt="Church"> </figure>
				 <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Church</span></h4>
				</span></a>
				</div>
				<div class="col-lg-3 hover mb-3"> 
			   <a href="https://www.exploreourindia.com/tag/mosque"> <span class="bdrhvr hover14">
			  <figure>  <img class="img-fluid rounded-circle mb-4" src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/mosque.webp" alt="Mosque"> </figure>
				 <h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Mosque</span></h4>
				</span></a>
				</div>				
                <div class="col-lg-12">
				  <p>India is a land of deep spirituality, home to sacred sites like the Char Dham, Golden Temple, Varanasi, and the temples of South India. From Hindu temples to Buddhist monasteries and Sikh gurudwaras, each destination offers a powerful blend of devotion, history, and culture. Perfect for pilgrims and spiritual travelers alike, these places inspire peace and connection across Incredible India.</p>
				</div>
		  <?php  
		    $relPostQuery = backend\models\TopPlaces::find()->where(['status' => 1, 'id' => 3])->one();	
		    $posttid = explode(',', $relPostQuery->post_id); 
			$j=1;
			foreach($posttid as $displayall) {
		    $PostrelQueryy = Post::find()->where(['status' => 1])->andwhere(['id' => $displayall])->one(); 
		  ?>
            <div class="col-lg-3 mb-4 pb-1">
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-2 mb-2">
                <div class="row">
                  <div class="col">
				    <?php if($PostrelQueryy->image != '') {?>
					  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$PostrelQueryy->image.'" alt="'.$PostrelQueryy->title.'" class="lazyload img-fluid border-radius-0" width="50" height="50"> ', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
					<?php } else { ?>
					   <?=Html::a('<img src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg" alt="'.$PostrelQueryy->title.'" class="img-fluid border-radius-0"> ', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
					<?php } ?> 
				  </div>
                </div>
                <div class="row">
                  <div class="col">
                    <div class="thumb-info-caption-text">                   
                      <h3 class="d-block line-height-2 text-4 mt-2 text-dark font-weight-bold mb-0"><?=Html::a($PostrelQueryy->title, ['/post/view', 'slug' => $PostrelQueryy->slug], ['class' => 'text-decoration-none text-color-dark'])?></h3>
                      <?=Html::a('<p class="mt-1" style="text-align:justify">'.$PostrelQueryy->limitTextWords(strip_tags($PostrelQueryy->content), 25, true, true).'</p>', ['/post/view', 'slug' => $PostrelQueryy->slug])?>
                                
                    </div>
                  </div>
                </div>                
              </article>          
            </div>
            <?php $j++; } ?>            
          </div>
        </div>      
        <div class="col-md-12">       
          <div class="heading heading-border heading-middle-border">
            <h3 class="text-4"><strong class="font-weight-bold text-2 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Explore India’s Top Adventure Escapes – Trekking, Climbing & Thrilling Experiences</strong></h3>
          </div>
          <p>India is a haven for adventure lovers, with breathtaking trekking trails across the Himalayas, Western Ghats, and Northeast. Whether it’s the vibrant Valley of Flowers, snowy Kedarkantha, or the serene Sandakphu trail, each trek offers stunning views and rich cultural encounters. Perfect for beginners and seasoned trekkers alike, these paths promise unforgettable moments in nature.</p>
          
          <div class="row pb-1">
            <div class="col-lg-6 mb-4 pb-1">
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-2 mb-2">
                <div class="row">
                  <div class="col">
                    <?=Html::a('<img src='.Yii::$app->urlManagerBackend->baseUrl.'/images/tag/big/'.$TagoneQuery->image.' alt="'.$TagoneQuery->name.'" class="lazyload img-fluid border-radius-0"> ', ['/tag/view', 'slug' => $TagoneQuery->slug])?>
				  </div>
                </div>
                <div class="row">
                  <div class="col">
                    <div class="thumb-info-caption-text">
                      <h4 class="d-block line-height-2 text-4 text-dark font-weight-bold mb-0 mt-2"> <?=Html::a($TagoneQuery->name, ['/tag/view', 'slug' => $TagoneQuery->slug], ['class' => 'text-decoration-none text-color-dark'])?> </h4>
                    </div>
                  </div>
                </div>
              </article>
            </div>
			<div class="col-lg-3">
			 <?php
             $TagoddQQuery = Tag::find()->where(['status' => 1])->where(['between', 'id', 1, 12])->andwhere(['!=', 'id', 2])->andwhere(['!=', 'id', $TagoneQuery->id])->andwhere(['%2<>','id',0])->orderBy('id')->limit(5)->all();    
			 foreach($TagoddQQuery as $tagdisplay) {?>
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4"> <?=Html::a('<img src='.Yii::$app->urlManagerBackend->baseUrl.'/images/tag/small/'.$tagdisplay->image.' alt="'.$tagdisplay->name.'" class="lazyload img-fluid border-radius-0"> ', ['/tag/view', 'slug' => $tagdisplay->slug])?>
				  </div>
                  <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                     
                      <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0 pt-1"> <?=Html::a($tagdisplay->name, ['/tag/view', 'slug' => $tagdisplay->slug], ['class' => 'text-decoration-none text-color-dark'])?></h4>
                    </div>
                  </div>
                </div>
              </article>
			 <?php } ?>
            </div>
            <div class="col-lg-3">
			 <?php
             $TagevenQQuery = Tag::find()->where(['status' => 1])->where(['between', 'id', 1, 12])->andwhere(['!=', 'id', 2])->andwhere(['!=', 'id', $TagoneQuery->id])->andwhere(['%2=','id',0])->orderBy('id')->limit(5)->all();  
			 foreach($TagevenQQuery as $tagdisplay) {?>
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4"> <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/tag/small/'.$tagdisplay->image.'" alt="'.$tagdisplay->name.'" class="lazyload img-fluid border-radius-0"> ', ['/tag/view', 'slug' => $tagdisplay->slug])?>
				  </div>
                  <div class="col-sm-7 pl-sm-0">
                    <div class="thumb-info-caption-text">                     
                      <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0 pt-1"> <?=Html::a($tagdisplay->name, ['/tag/view', 'slug' => $tagdisplay->slug], ['class' => 'text-decoration-none text-color-dark'])?></h4>
                    </div>
                  </div>
                </div>
              </article>
			 <?php } ?>
            </div>			
          </div>
          </div>          
           
          <div class="col-md-9">          
          <div class="heading heading-border heading-middle-border">
            <h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-tertiary">Uncover India’s Rich Heritage – Forts, Palaces, Temples & Historical Wonders</strong></h3>
          </div>
		  <?=Html::a('<img src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/heritage211.gif" alt="Uncover India’s Rich Heritage – Forts, Palaces, Temples & Historical Wonders" class="img-fluid border-radius-0"> ', ['/category/view', 'slug' => 'heritage'])?>
          <p>India’s heritage is a rich mosaic of majestic forts, ancient temples, royal palaces, and UNESCO World Heritage Sites. From the Taj Mahal to the Ajanta and Ellora caves, each monument echoes the country’s glorious past and architectural brilliance. Exploring these historic treasures offers a deep dive into India’s timeless culture and traditions.</p>
          
          <div class="row pb-1">            
            <div class="col-lg-12">
			  <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
               <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/taj-mahal"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/taj-mahal-Agra.gif" class="img-fluid border-radius-0" alt="Taj mahal, Agra"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/taj-mahal" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0"> Taj mahal, Agra </h4>
                      <p>Taj Mahal is the epitome of grandeur and splendor, you cannot fathom the beauty of this white-marbled monument unless you stand in front of it. As you approach the Taj Mahal, it gradually becomes known to you that this is no ordinary monument, but a vision come to life! Moved by its beauty and the deep affection of Shah Jahan for Mumtaz, the Nobel Laureate Rabindranath Tagore called it "a teardrop on the face of eternity".</p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/red-fort"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/red-fort-delhi.gif" class="img-fluid border-radius-0" alt="Red Fort, Delhi"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/red-fort" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0">Red Fort, Delhi </h4>
                      <p>The Red Fort is a historical fortification in the old Delhi area. Shah Jahan constructed it in the year 1639 as a result of a capital shift from Agra to Delhi. Used as the main residence of the emperors of the Mughal dynasty, this imposing piece of architecture derives its name from its impregnable red sandstone walls. In addition to accommodating the emperors and their households, it was the ceremonial and political center of the Mughal state and the setting for events critically impacting the region. </p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/rani-ki-vav"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/rani-ki-vav-gujarat.gif" class="img-fluid border-radius-0" alt="Rani-ki-Vav, Gujarat"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/rani-ki-vav" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0 ">Rani-ki-Vav, Gujarat </h4>
                        
                      <p>Rani-ki-Vav, on the banks of the Saraswati River, was initially built as a memorial to a king in the 11th century AD. Stepwells are a distinctive form of subterranean water resource and storage systems on the Indian subcontinent and have been constructed since the 3rd millennium BC. </p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/kaziranga-national-park-and-tiger-reserve"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/kaziranga-national-park-assam.gif" class="img-fluid border-radius-0" alt="Kaziranga National Park, Assam"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/kaziranga-national-park-and-tiger-reserve" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0"> Kaziranga National Park, Assam </h4>
                      <p>All those who have thought Indian one-horned rhinoceros only existed in the Jurassic era, then a trip to Kaziranga is a must for them. One of the most sought-after wildlife holiday destinations in India, Kaziranga National park’s 430 square kilometer area sprinkled with elephant-grass meadows, swampy lagoons, and dense forests are home to more than 2200 Indian one-horned rhinoceros, approximately 2/3rd of their total world population.</p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
              
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-4 mb-2">
                <div class="row align-items-center pb-1">
                  <div class="col-sm-4">
                   <a href="https://www.exploreourindia.com/khangchendzonga-national-park"> <img src="<?=Yii::$app->urlManagerFrontend->baseUrl?>/images/khangchendzonga-national-park-sikkim.gif" class="img-fluid border-radius-0" alt="Khangchendzonga National Park, Sikkim"> </a> 
                  </div>
                  <a href="https://www.exploreourindia.com/khangchendzonga-national-park" class="text-decoration-none text-color-dark"> <div class="col-sm-8 pl-sm-0">
                    <div class="thumb-info-caption-text">
                        <h4 class="d-block pb-2 line-height-2 text-3 text-dark font-weight-bold mb-0 ">Khangchendzonga National Park, Sikkim </h4>
                        
                      <p>Khangchendzonga National Park is a UNESCO World Heritage Site and it covers an area of 1784 sq km. This high-altitude national park in Yuksom is known for its spectacular wildlife where exotic animal species such as Red Panda, Snow Leopard, Great Tibetan Sheep, Bharal, Musk deer, etc can be spotted. </p>
                    </div>
                    </a>
                  </div>
                </div>
              </article>
			<?=Html::a('More heritage sites', ['/category/view', 'slug' => 'heritage'], ['class' => 'btn btn-primary btn-block mb-2', 'style' => 'padding: 10px 5px;font-size: 13px;'])?>
              <br><br>
            </div>
          </div>
		  
		  <div class="heading heading-border heading-middle-border">
            <h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-quaternary">Ecotourism and Leisure in India: Embrace Nature and Relaxation</strong></h3>
          </div>   
          
            <div class="box11">
          <div class="container">
          <div class="row pb-1">
          <div class="col-lg-12 float-left">
           <div class="col-lg-4 hover mb-5 float-left"> 
			<?=Html::a('<span class="bdrhvr hover14"><figure> <img class="img-fluid rounded-circle mb-4 " src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/lake.webp" alt="Lake" width="100%"> </figure><h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Lake</span></h4></span>', ['/tag/view', 'slug' => 'lake'])?>
            </div>
            
            <div class="col-lg-4 hover mb-5 float-left"> 
			<?=Html::a('<span class="bdrhvr hover14"><figure> <img class="img-fluid rounded-circle mb-4 " src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/water fall.gif" alt="Lake" width="100%"> </figure><h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Waterfall</span></h4></span>', ['/tag/view', 'slug' => 'waterfalls'])?>
            </div>
			
			<div class="col-lg-4 hover mb-5 float-left"> 
			<?=Html::a('<span class="bdrhvr hover14"><figure> <img class="img-fluid rounded-circle mb-4 " src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/national park.gif" alt="Lake" width="100%"> </figure><h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">National Park</span></h4></span>', ['/tag/view', 'slug' => 'national-park'])?>
            </div>
			
			<div class="col-lg-4 hover mb-5 float-left"> 
			<?=Html::a('<span class="bdrhvr hover14"><figure> <img class="img-fluid rounded-circle mb-4 " src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/beach.gif" alt="Lake" width="100%"> </figure><h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Beach</span></h4></span>', ['/tag/view', 'slug' => 'beach'])?>
            </div>
			
			<div class="col-lg-4 hover mb-5 float-left"> 
			<?=Html::a('<span class="bdrhvr hover14"><figure> <img class="img-fluid rounded-circle mb-4 " src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/island.gif" alt="Lake" width="100%"> </figure><h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Island</span></h4></span>', ['/tag/view', 'slug' => 'island'])?>
            </div>
            
            <div class="col-lg-4 hover mb-5 float-left"> 
			<?=Html::a('<span class="bdrhvr hover14"><figure> <img class="img-fluid rounded-circle mb-4 " src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/wildlife santury.gif" alt="Lake" width="100%"> </figure><h4 class="text-5 text-center font-weight-bold mt-1 text-secondary"><span class="alternative-font">Wildlife Sanctuary</span></h4></span>', ['/tag/view', 'slug' => 'wildlife-sanctuary'])?>
            </div>           

            </div>
          </div>
          </div>
         </div>
          <br>
          
          <div class="heading heading-border heading-middle-border">
            <h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-quaternary" style="background-color: #ff671f !important;">Top Tourist Places to Visit in India – Explore Popular & Hidden Gems</strong></h3>
          </div>
          <div class="row pb-1">
		  <?php  
		    $postid = explode(',', $topplacesQuery->post_id);
			foreach($postid as $displayall) {
		    $allpostQuery = Post::find()->where(['status' => 1])->andwhere(['id' => $displayall])->one(); 
		  ?>
		  
            <div class="col-lg-3 mb-4 pb-1">
              <article class="thumb-info thumb-info-side-image thumb-info-no-zoom bg-transparent border-radius-0 pb-2 mb-2">
                <div class="row">
                  <div class="col">
  				    <?php if($allpostQuery->image != '') {?>
					  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$allpostQuery->image.'" alt="'.$allpostQuery->title.'" class="lazyload img-fluid border-radius-0"> ', ['/post/view', 'slug' => $allpostQuery->slug])?>
					<?php } else { ?>
					   <?=Html::a('<img src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg" alt="'.$allpostQuery->title.'" class="lazyload img-fluid border-radius-0"> ', ['/post/view', 'slug' => $allpostQuery->slug])?>
					<?php } ?> 
				 </div>
                </div>
                <div class="row">
                  <div class="col">
                    <div class="thumb-info-caption-text">
                      <h3 class="d-block line-height-2 text-4 text-dark font-weight-bold mb-0 margtoptext">
                       <?=Html::a($allpostQuery->title, ['/post/view', 'slug' => $allpostQuery->slug], ['class' => 'text-decoration-none text-color-dark'])?>
					  </h3>
                    </div>
                  </div>
                </div>
              </article>
            </div>
            <?php } ?>
            </div>
          </div>
          <style>
          .popularimg{
			  width:90px;
			  height:50px;}
          </style>

        <div class="col-lg-3 ">
        <div class="hpanel panel-group sidebar" id="accordion" >
			  <div class="heading heading-border heading-middle-border">
				<h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Popular Blogs</strong></h3>
			  </div>
              <ul class="simple-post-list" aria-label="Popular Blogs" title="Popular Blogs">
			  <?php $i=1; foreach($popularBlog as $popularBlogg) {?>
                <li>
                  <article>
                    <div class="post-image">
                      <div class="img-thumbnail img-thumbnail-no-borders d-block">
					    <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$popularBlogg->image.'" alt="'.$popularBlogg->heading.'" class="lazyload border-radius-0 popularimg">', ['/blog/view', 'slug' => $popularBlogg->slug])?>
					  </div>
                    </div>
					<?=Html::a('<div class="post-info"><h4 class="font-weight-bold text-3 mb-0" style="line-height: 20px;">'.$popularBlogg->heading.'</h4><p>'.$popularBlogg->limitTextWords(strip_tags($popularBlogg->content), 20, true, true).'</p></div>', ['/blog/view', 'slug' => $popularBlogg->slug])?>
                  </article>
                </li>
                
               <!-- <?php if($i == 2) {?>
                <li>
                  <article>
                  <div class="eg-affiliate-banners" data-program="us-expedia" data-network="pz" data-layout="medium-rectangle" data-image="relaxing" data-message="find-perfect-getaway-package" data-link="packages" data-camref="1101lLvdB" data-pubref=""></div>
<script class="eg-affiliate-banners-script" src="https://affiliates.expediagroup.com/products/banners/assets/eg-affiliate-banners.js"></script>
                   
                  </article>
                  </li>
                <?php } ?>-->
                
                
               <!-- <?php if($i == 7) {?>
                <li>
                  <article>
                  <div class="eg-affiliate-banners" data-program="us-expedia" data-network="pz" data-layout="medium-rectangle" data-image="relaxing" data-message="find-perfect-getaway-package" data-link="packages" data-camref="1101lLvdB" data-pubref=""></div>
<script class="eg-affiliate-banners-script" src="https://affiliates.expediagroup.com/products/banners/assets/eg-affiliate-banners.js"></script>
                   
                  </article>
                  </li>
                <?php } ?>-->
                
               
                
                
				<?php $i++; } ?>
                
              </ul>
          
        </div>
      </div>
      </div>
    </div>
  </div>
  
  <div class="container py-4">
      <div class="row">
        <div class="col">
          <h2 aria-label="States and Union Territories" style="margin: 0 0 7px 0;">Explore Indian States and Union Territories – Travel Guides by Region</h2>
          <div class="owl-carousel owl-theme show-nav-title top-border mb-0 owl-loaded owl-drag owl-carousel-init" data-plugin-options="{'responsive': {'0': {'items': 1}, '479': {'items': 1}, '768': {'items': 2}, '979': {'items': 5}, '1199': {'items': 5}}, 'items': 5, 'margin': 10, 'loop': false, 'nav': true, 'dots': false}" style="height: auto;">
            <div class="owl-stage-outer">
              <div class="owl-stage" style="transform: translate3d(0px, 0px, 0px); transition: all 0.25s ease 0s; width: 2614px;">
                <?php foreach($modelstate as $modelstateall) {?>
              <div class="owl-item active col-lg-3" style="margin-right: 10px;">
                  <div>
                    <div class="recent-posts">
                      <article class="post">
                      <?php if($modelstateall->image != '') {?>
					   <?= Html::a("<img src='".Yii::$app->urlManagerBackend->baseUrl.'/images/state/'.$modelstateall->image."' alt='".$modelstateall->state_name."' class='img-fluid border-radius-0'>",['/state/view/', 'slug' => $modelstateall->slug])  ?>
					<?php } else { ?>
					  <?= Html::a("<img src='".Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg'."' alt='".$modelstateall->state_name."' class='img-fluid border-radius-0'>",['/state/view/', 'slug' => $modelstateall->slug])  ?>
					<?php } ?>
                    <div class="row">
					  <div class="col">
						<div class="thumb-info-caption-text sidebar">
							<?=Html::a('<aside class="aside"><h3 class="aside-title" style="border-radius: 3px; margin-top:-10px;">'.$modelstateall->state_name.'</h3></aside>', ['/state/view', 'slug' => $modelstateall->slug], ['class' => 'text-decoration-none text-color-light'])?>
						</div>
					  </div>
					</div>
                </article>
                </div>
              </div>
            </div>
				<?php } ?>              
              </div>
            </div>
            <div class="owl-nav">
              <button type="button" role="presentation" class="owl-prev disabled" aria-label="previous" name="previous"></button>
              <button type="button" role="presentation" class="owl-next" aria-label="next" name="next"></button>
            </div>
            <div class="owl-dots disabled"></div>
          </div>
          
          <div class="col-lg-12 mt-3">
            <?=Html::a('All States and Union Territories', ['/state/index'], ['class' => 'btn btn-primary btn-block mb-2'])?>
          </div>
        </div>
       </div>
    </div>
	
  
     <div role="main" class="main pt-3 mt-3">
    <div class="container">
      <div class="row pb-3">
      <div class="col-lg-9">
      <!-- wyto ads <div class="text-center py-3 mb-4"> <img alt="Explore our India" class="img-fluid pl-3" src="<?php echo Yii::$app->urlManagerFrontend->baseUrl.'/images/blog-ad-2.jpg'?>" /> </div>-->
      </div>
  <div class="col-md-12">          
          
          <div class="row pb-1 pt-3">
            <div class="col-md-4">
              <div class="heading heading-border heading-middle-border">
				<h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Popular Travel Stories</strong></h3>
			  </div>
              <ul class="simple-post-list">
                <?php foreach($popularpost as $popularposts) {?>
				  <li>
					  <article>
						<div class="post-image">
						  <div class="img-thumbnail img-thumbnail-no-borders d-block">
							 <?php if($popularposts->image != '') {?>
							  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/post/big/'.$popularposts->image.'" alt="'.$popularposts->title.'" class="lazyload border-radius-0 popularimg"> ', ['/post/view', 'slug' => $popularposts->slug])?>
							<?php } else { ?>
							   <?=Html::a('<img src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg" alt="'.$popularposts->title.'" class="border-radius-0 popularimg"> ', ['/post/view', 'slug' => $popularposts->slug])?>
							<?php } ?> 
						  </div>
						</div>
						<div class="post-info">
						  <h4 class="font-weight-normal text-3 mb-0" style="line-height:22px">
						  <?=Html::a($popularposts->title, ['/post/view', 'slug' => $popularposts->slug], ['class' => 'text-dark'])?>
						  </h4>
						</div>
					  </article>
					</li>
				<?php } ?>
              </ul>
            </div>
            <div class="col-md-4">
              <div class="heading heading-border heading-middle-border">
				<h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Explore Recent Blogs</strong></h3>
			  </div>
              <ul class="simple-post-list">
                 <?php foreach($recentBlog as $recentBlogg) {?>
				  <li>
					  <article>
						<div class="post-image">
						  <div class="img-thumbnail img-thumbnail-no-borders d-block">
							 <?php if($recentBlogg->image != '') {?>
							  <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/blog/'.$recentBlogg->image.'" alt="'.$recentBlogg->heading.'" class="lazyload border-radius-0 popularimg">', ['/blog/view', 'slug' => $recentBlogg->slug])?>
							<?php } else { ?>
							   <?=Html::a('<img src="'.Yii::$app->urlManagerFrontend->baseUrl.'/images/photo-not-availabe.jpg" alt="'.$recentBlogg->heading.'" class="lazyload border-radius-0 popularimg"> ', ['/blog/view', 'slug' => $recentBlogg->slug])?>
							<?php } ?> 
						  </div>
						</div>
						<div class="post-info">
						  <h4 class="font-weight-normal text-3 mb-0" style="line-height:22px">
						  <?=Html::a($recentBlogg->heading, ['/blog/view', 'slug' => $recentBlogg->slug], ['class' => 'text-dark'])?>
						  </h4>
						</div>
					  </article>
					</li>
				<?php } ?>
              </ul>
            </div>
	
            <div class="col-md-4">
              <div class="heading heading-border heading-middle-border">
				<h3 class="text-4"><strong class="font-weight-bold text-1 px-3 text-light py-2 bg-secondary" style="background-color: #ff671f !important;">Top Adventure Activities in India</strong></h3>
			  </div>
              <ul class="simple-post-list">
			  <?php
				 $TagQuery = Tag::find()->where(['status' => 1])->orderBy('id')->limit(10)->all();    
				 foreach($TagQuery as $tagdisplay) {?>
                <li>
                  <article>
                    <div class="post-image">
                      <div class="img-thumbnail img-thumbnail-no-borders d-block">
					   <?=Html::a('<img src="'.Yii::$app->urlManagerBackend->baseUrl.'/images/tag/small/'.$tagdisplay->image.'" alt="'.$tagdisplay->name.'" class="lazyload border-radius-0 popularimg" > ', ['/tag/view', 'slug' => $tagdisplay->slug])?>
                      </div>
                    </div>
                    <div class="post-info">
                      <h4 class="font-weight-normal text-3 mb-0" style="line-height:22px">
					  <?=Html::a($tagdisplay->name, ['/tag/view', 'slug' => $tagdisplay->slug], ['class' => 'text-dark'])?>
					  </h4>
                    </div>
                  </article>
                </li>
				<?php } ?>
              </ul>
            </div>
          </div>
          
          <!-- Google adsense -->
          <!--<script async src="https://pagead2.googlesyndication.com/pagead/js/adsbygoogle.js?client=ca-pub-3311269295796373"
     crossorigin="anonymous"></script>
<ins class="adsbygoogle"
     style="display:block"
     data-ad-format="autorelaxed"
     data-ad-client="ca-pub-3311269295796373"
     data-ad-slot="2887776118"></ins>
<script>
     (adsbygoogle = window.adsbygoogle || []).push({});
</script>-->
<!-- Google adsense -->
          
        </div>
    </div>
</div>
</div>
    
<style>
#feedback {
	height: 600px;
	width: 160px;
	position: fixed;
	right: 0;
	top: 20%;
	z-index: 1000;
	transform: rotate(-90deg);
	-webkit-transform: rotate(0deg);
	-moz-transform: rotate(-90deg);
	-o-transform: rotate(-90deg);
	filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);
}
#feedback a {
	display: block;
	background:#000;
	height: 500px;
	padding-top: 10px;
	width: 160px;
	text-align: center;
	color: #fff;
	font-family: Arial, sans-serif;
	font-size: 17px;
	font-weight: bold;
	text-decoration: none;
}
#feedback1 {
	height: 600px;
	width: 160px;
	position: fixed;
	left: 0;
	top: 20%;
	z-index: 1000;
	transform: rotate(-90deg);
	-webkit-transform: rotate(0deg);
	-moz-transform: rotate(-90deg);
	-o-transform: rotate(-90deg);
	filter: progid:DXImageTransform.Microsoft.BasicImage(rotation=3);
}
#feedback1 a {
	display: block;
	background:#930;
	height: 500px;
	padding-top: 10px;
	width: 160px;
	text-align: center;
	color: #fff;
	font-family: Arial, sans-serif;
	font-size: 17px;
	font-weight: bold;
	text-decoration: none;
}
</style>